/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWReceiveAdvancedPanel;
import filenet.vw.toolkit.runtime.property.VWReceiveCorrelationSetPanel;
import filenet.vw.toolkit.runtime.property.VWReceiveGeneralPanel;
import filenet.vw.toolkit.runtime.property.VWSystemStepGeneralPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWReceiveParamPanel
extends JPanel {
    protected static final int MODE_BASIC = 0;
    protected static final int MODE_ADVANCED = 1;
    private VWSystemStepGeneralPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private VWReceiveGeneralPanel m_generalPanel = null;
    private VWReceiveAdvancedPanel m_advancedPanel = null;
    private VWReceiveCorrelationSetPanel m_correlationSetsPanel = null;
    protected JTabbedPane m_receiveTabbedPane = null;

    public VWReceiveParamPanel(VWSystemStepGeneralPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.init();
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        if (instructionDef instanceof VWReceiveInstruction) {
            VWReceiveInstruction receive = (VWReceiveInstruction)instructionDef;
            this.m_instructionDef = receive;
            this.m_generalPanel.setInstructionDefinition(receive);
            this.m_advancedPanel.setInstructionDefinition(receive);
            this.m_correlationSetsPanel.setInstructionDefinition(receive);
        }
    }

    private void init() {
        this.setupLayout();
        this.m_receiveTabbedPane.setTabPlacement(1);
        this.m_generalPanel = new VWReceiveGeneralPanel(this, this.m_tableCellRenderer, this.m_instructionDef);
        this.m_advancedPanel = new VWReceiveAdvancedPanel(this, this.m_instructionDef);
        this.m_correlationSetsPanel = new VWReceiveCorrelationSetPanel(this, this.m_tableCellRenderer, this.m_instructionDef);
        this.m_receiveTabbedPane.addTab(VWResource.s_general, this.m_generalPanel);
        this.m_receiveTabbedPane.addTab(VWResource.s_advanced, this.m_advancedPanel);
        this.m_receiveTabbedPane.addTab(VWResource.s_correlationSet, this.m_correlationSetsPanel);
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.fill = 1;
        gbCons.anchor = 10;
        this.m_receiveTabbedPane = new JTabbedPane();
        this.add((Component)this.m_receiveTabbedPane, gbCons);
    }

    protected int getReceiveMessageType() {
        try {
            if (this.m_instructionDef != null) {
                if (((VWReceiveInstruction)this.m_instructionDef).getMessageExpr() == null) {
                    return 0;
                }
                return 1;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    protected Object getTypeFromParam(VWWebServiceParameterDefinition paramDef) {
        return this.m_parent.getTypeFromParam(paramDef);
    }

    protected void setTextField(JTextField field, String text) {
        this.m_parent.setTextField(field, text);
    }

    protected VWSchema getSchemaFromWorkflow(String name) {
        return this.m_parent.getSchemaFromWorkflow(name);
    }

    protected void setupTableCellRenderer(VWTable table, AbstractTableModel tableModel) {
        this.m_parent.setupTableCellRenderer(table, tableModel);
    }

    public void removeReferences() {
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removeReferences();
        }
        if (this.m_advancedPanel != null) {
            this.m_advancedPanel.removeReferences();
        }
        if (this.m_correlationSetsPanel != null) {
            this.m_correlationSetsPanel.removeReferences();
        }
        this.m_receiveTabbedPane = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

